/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.network.commands.argument.ColorArgument;
import moze_intel.projecte.network.commands.argument.UUIDArgument;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ShowBagCMD {
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)PELang.SHOWBAG_NOT_FOUND.translate(new Object[0]));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"showbag").requires(cs -> cs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"color", (ArgumentType)new ColorArgument()).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> ShowBagCMD.showBag((CommandContext<CommandSourceStack>)ctx, ColorArgument.getColor(ctx, "color"), EntityArgument.m_91474_((CommandContext)ctx, (String)"target"))))).then(Commands.m_82129_((String)"uuid", (ArgumentType)new UUIDArgument()).executes(ctx -> ShowBagCMD.showBag((CommandContext<CommandSourceStack>)ctx, ColorArgument.getColor(ctx, "color"), UUIDArgument.getUUID(ctx, "uuid")))));
    }

    private static int showBag(CommandContext<CommandSourceStack> ctx, DyeColor color, ServerPlayer player) throws CommandSyntaxException {
        ServerPlayer senderPlayer = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return ShowBagCMD.showBag(senderPlayer, ShowBagCMD.createContainer(senderPlayer, player, color));
    }

    private static int showBag(CommandContext<CommandSourceStack> ctx, DyeColor color, UUID uuid) throws CommandSyntaxException {
        ServerPlayer senderPlayer = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return ShowBagCMD.showBag(senderPlayer, ShowBagCMD.createContainer(senderPlayer, uuid, color));
    }

    private static int showBag(ServerPlayer senderPlayer, MenuProvider container) {
        NetworkHooks.openGui((ServerPlayer)senderPlayer, (MenuProvider)container, b -> {
            b.writeBoolean(false);
            b.writeBoolean(false);
        });
        return 1;
    }

    private static MenuProvider createContainer(ServerPlayer sender, ServerPlayer target, DyeColor color) {
        IItemHandlerModifiable inv = (IItemHandlerModifiable)((IAlchBagProvider)target.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).orElseThrow(NullPointerException::new)).getBag(color);
        TranslatableComponent name = PELang.SHOWBAG_NAMED.translate(new Object[]{PEItems.getBag(color), target.m_5446_()});
        return ShowBagCMD.getContainer(sender, (Component)name, inv, false, () -> target.m_6084_() && !target.m_9232_());
    }

    private static MenuProvider createContainer(ServerPlayer sender, UUID target, DyeColor color) throws CommandSyntaxException {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        IItemHandlerModifiable inv = ShowBagCMD.loadOfflineBag(server, target, color);
        Optional profileByUUID = server.m_129927_().m_11002_(target);
        Object name = profileByUUID.isPresent() ? PELang.SHOWBAG_NAMED.translate(new Object[]{PEItems.getBag(color), ((GameProfile)profileByUUID.get()).getName()}) : TextComponentUtil.build(new Object[]{PEItems.getBag(color)});
        return ShowBagCMD.getContainer(sender, (Component)name, inv, true, () -> true);
    }

    private static MenuProvider getContainer(final ServerPlayer sender, final Component name, final IItemHandlerModifiable inv, final boolean immutable, final BooleanSupplier canInteractWith) {
        return new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return name;
            }

            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInv, @NotNull Player player) {
                return new AlchBagContainer(windowId, sender.m_150109_(), InteractionHand.OFF_HAND, inv, 0, immutable){

                    @Override
                    public boolean m_6875_(@NotNull Player player) {
                        return canInteractWith.getAsBoolean();
                    }
                };
            }
        };
    }

    private static IItemHandlerModifiable loadOfflineBag(MinecraftServer server, UUID playerUUID, DyeColor color) throws CommandSyntaxException {
        File player;
        File playerData = server.m_129843_(LevelResource.f_78176_).toFile();
        if (playerData.exists() && (player = new File(playerData, playerUUID.toString() + ".dat")).exists() && player.isFile()) {
            IItemHandlerModifiable iItemHandlerModifiable;
            FileInputStream in = new FileInputStream(player);
            try {
                CompoundTag playerDat = NbtIo.m_128939_((InputStream)in);
                CompoundTag bagProvider = playerDat.m_128469_("ForgeCaps").m_128469_(AlchBagImpl.Provider.NAME.toString());
                IAlchBagProvider provider = AlchBagImpl.getDefault();
                provider.deserializeNBT((Tag)bagProvider);
                iItemHandlerModifiable = (IItemHandlerModifiable)provider.getBag(color);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            in.close();
            return iItemHandlerModifiable;
        }
        throw NOT_FOUND.create();
    }
}

